/********
* pp1.cpp
*
* CS148 Project 1: Scan Conversion / Drawing Tool
*
* Sean Walker, Rachel Weinstein, and Dan Morris
*
*********/

#include "cs148.h"

// For parsing
#include <fstream>
#include <iostream>
#include <string>
#include <sstream>

using namespace std;

// Window name -- add your name to it!
const char *windowName = "CS148 PP1: <your name here>";

// Start up message
const char *startMessage = 
"Usage: pp1 <filename>\n"
"  <filename> for an descriptor file (to draw an image)\n\n"
"PP1 Controls:\n"
"  Modes:\n"
"    'P' points \n"
"    'L' lines \n"
"    'C' circles \n"
"    'Y' polylines \n"
"    'R' rectangles\n"
"    'F' floodfill\n"
"    'A' airbrush\n"
"  \n"
"  Change color:\n"
"    [0-9]\n"
"  \n"
"  Other Controls:\n"
"    'X' clear screen\n"
"    'B' toggle pixel size (big or small)\n"
"    'D' toggle draw delay\n"
"    'Q' quit\n";



// Modes
enum {
  MODE_POINTS=0,   // Already implemented
  MODE_LINES,      // Needs the scan conversion function
  MODE_CIRCLES,    // Needs the scan conversion function
  MODE_POLYLINES,  // Needs mouse click handling and scan conversion
  MODE_RECTANGLES, // Needs mouse click handling and scan conversion
  MODE_FLOODFILL,  // Needs mouse click handling and scan conversion
  MODE_AIRBRUSH    // Needs mouse click handling and scan conversion
};
int nMode = MODE_POINTS;


// Mouse start location for those primitives that take two points.
int nGotStart = 0;        // Set to 1 when starting pixel is found
int nStartX = 0, nStartY = 0; // Starting location

// Number of pixels in the x and y directions
//
// Automatically updated if the user resizes the window
int numPixelsX;
int numPixelsY;

// Some simple colors you can use.  The rgb class represents a
// color, and it's defined in cs148.h.
// 
// Feel free to add more of your own colors.

rgb WHITE(1.0,1.0,1.0);
rgb BLACK(0.0,0.0,0.0);
rgb RED  (1.0,0.0,0.0);
rgb GREEN(0.0,1.0,0.0);
rgb BLUE (0.0,0.0,1.0);

rgb colors[10] = {
  WHITE,BLACK,RED,GREEN,BLUE,
  WHITE,WHITE,WHITE,WHITE,WHITE
  };

// This is the color currently being used to draw to the screen.
//
// Black by default.
rgb currentDrawColor = BLACK;

// Declare the setPixel function -- the only drawing function you should use 
// in this project.  Sets the color of pixel (x,y) to 'color'
void setPixel(const int& x, const int& y, const rgb& color);

// Declare the getPixel function -- used to retrieve the value of a pixel.
//
// Gives you the color at pixel (x,y)
rgb getPixel(const int& x, const int& y);


//***************************************************************************
// Finish these functions for your solution.
//***************************************************************************


// Bresenham line function -- you should fill this out.
void drawLine(int startx, int starty, int endx, int endy) {
  cout << "drawLine() not implemented yet." << endl;
}


// Bresenham circle function -- you should fill this out.
void drawCircle(int x, int y, int radius) {
  cout << "drawCirle() not implemented yet." << endl;
}


// Mouse function -- this is called every time the left mouse button is clicked.
void mouseClick(int x, int y) {

  // What we do depends on what mode we're in
  switch (nMode) {

  case MODE_POINTS:
    setPixel(x, y, currentDrawColor);
    break;

  case MODE_LINES:

    // If we haven't gotten our start point yet, this
    // is our start point.
    if (!nGotStart) {
      nStartX = x;
      nStartY = y;
      nGotStart = 1;
    }

    // We've already gotten our start point, so go ahead and draw
    // a line. 
    else {
      drawLine(nStartX, nStartY, x, y);
      nGotStart = 0;
    }

    break;

  case MODE_CIRCLES:

    // If we haven't gotten our start point yet, this
    // is our start point.
    if (!nGotStart) {
      nStartX = x;
      nStartY = y;
      nGotStart = 1;
    }

    // We've already gotten our start point, so go ahead and draw
    // a circle. 
    else {

      // compute a radius based on the center point and the current point
      int radius = (int)sqrt((double)((x - nStartX) * (x - nStartX) + 
                   (y - nStartY) * (y - nStartY)));
      drawCircle(nStartX, nStartY, radius);
      nGotStart = 0;
    }

    break;

  case MODE_POLYLINES:
    cout << "Polylines not implemented yet." << endl;
    break;

  case MODE_RECTANGLES:
    cout << "Rectangles not implemented yet." << endl;
    break;

  case MODE_FLOODFILL:
    cout << "Floodfill not implemented." << endl;
    break;

  case MODE_AIRBRUSH:
    cout << "Airbrush not implemented." << endl;
    break;
  };
}

// Mouse function -- this is called every time the mouse is
// dragged with the left button down.
//
// You don't need to use this, but it might be fun.
void mouseDrag(int x, int y) {

  // What we do depends on what mode we're in
  switch (nMode) {

  }

};



//***************************************************************************
// You shouldn't need to edit anything past this point, but feel free to
// explore.
//***************************************************************************


// Virtual pixel sizes 
//
// Note: this is handled transparently by code in the mouse and 
// display routines.
const int SMALL_PIX_SIZE = 2;
const int BIG_PIX_SIZE = 8;
int nPixelSize = SMALL_PIX_SIZE;

// Delay data -- causes small delay after each pixel is drawn, for
// debugging.
const double SMALL_DELAY_TIME = 0.005;
const double BIG_DELAY_TIME = 0.050;
int nDelay = 0;

// Did the user specify a file at the command line?
int fileFound = 0;

// Are we parsing a file right now?
int parsing = 0;

// The filename passed in on the command line
const char* parseFile;

// Declare the parsing function -- used to read in files
void parse( const char* filename );

// Screen size
int screenHeight = 480;
int screenWidth = 640;


// Pixel drawing function 
void setPixel(const int& x, const int& y, const rgb& color) {

  // Draw pixel
  glColor3f(color.r, color.g, color.b);
  glBegin(GL_POINTS);
  glVertex2i(x * nPixelSize + nPixelSize / 2, y * nPixelSize + nPixelSize / 2);
  glEnd();
  glFlush();

  // Delay if needed, for debugging
  if ((nDelay) && (!parsing)) {
    double t = CS148::getTime();

    // We delay longer for bigger pixels
    double delay =
      (nPixelSize == BIG_PIX_SIZE ? BIG_DELAY_TIME : SMALL_DELAY_TIME);
    while (t + delay > CS148::getTime()); 
  }
}


// Pixel reading function -- returns the color at position (x,y)
rgb getPixel(const int& x, const int& y) {

  rgb toReturn; 
  glReadPixels(
    x * nPixelSize + nPixelSize / 2,
    y * nPixelSize + nPixelSize / 2, 1, 1, 
    GL_RGB, GL_FLOAT, ((float*)(&toReturn))
    );
  return toReturn;
}


// Initialization code
void initialize(void) {

  // White background
  glClearColor(1.0,1.0,1.0,1.0);
  glColor3f(currentDrawColor.r,currentDrawColor.g,currentDrawColor.b);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, (GLdouble)screenWidth, 0.0, (GLdouble)screenHeight);
  glPointSize((GLfloat)nPixelSize);

}


// Track whether the left button is pressed
int buttonDown = 0;

// Mouse click function
//   button = GLUT_LEFT_BUTTON, GLUT_MIDDLE_BUTTON, or GLUT_RIGHT_BUTTON
//   state =  GLUT_UP or GLUT_DOWN
//   x, y = mouse location
void mouseClickCallback(int button, int state, int x, int y) {

  // Catch left mouse buttons and pass them to the user.
  if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {
    mouseClick(x / nPixelSize, ((screenHeight - 1) - y) / nPixelSize);
    buttonDown = 1;
  }
  else if (button == GLUT_LEFT_BUTTON) {
    buttonDown = 0;
  }
}


// Mouse drag function
//   x, y = mouse location
void mouseDragCallback(int x, int y) {

  // This function doesn't tell us which button is down, so we
  // rely on remembering what we saw the last time our mouse-click
  // callback was called.
  if (buttonDown) {
    mouseDrag(x / nPixelSize, ((screenHeight - 1) - y) / nPixelSize);
  }
}

// Display function -- called to redraw window (blank, for now)
void redraw(void) {
  glClear(GL_COLOR_BUFFER_BIT);
  nGotStart = 0;
  if (fileFound) parse(parseFile);
}


// Reshape function -- called whenever window size changes
//   w, h = new window size
void reshape(int w, int h) {

  cout << "Screen resized to " << w << " " << h << endl;  
  screenWidth = w;
  screenHeight = h;
  glViewport(0, 0, screenWidth, screenHeight);  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, (GLdouble)screenWidth, 0.0, (GLdouble)screenHeight);
  glClear(GL_COLOR_BUFFER_BIT);
  nGotStart = 0;
  numPixelsX = screenWidth / nPixelSize;
  numPixelsY = screenHeight / nPixelSize;
}


// Keyboard function -- edit to add extra modes
//   key = ASCII key value
//   x, y = mouse location where keypress occurred
void keyDownCallback(unsigned char key, int x, int y) {

  if (key >= '0' && key <= '9') {
    int color = key - '0';
    currentDrawColor = colors[color];
    return;
  }

  key = tolower(key);

  switch (key) {
  case 'p':
    cout << "Point mode\n";
    nMode = MODE_POINTS;
    break; 
  case 'l':
    cout << "Line mode\n";
    nMode = MODE_LINES;
    nGotStart = 0;
    break; 
  case 'c':
    cout << "Circle mode\n";
    nMode = MODE_CIRCLES;
    nGotStart = 0;
    break; 
  case 'y':
    cout << "Polyline mode\n";
    nMode = MODE_POLYLINES;
    nGotStart = 0;
    break; 
  case 'r':
    cout << "Rectangle mode\n";
    nMode = MODE_RECTANGLES;
    nGotStart = 0;
    break; 
  case 'f':
    cout << "Floodfill mode\n";
    nMode = MODE_FLOODFILL;
    nGotStart = 0;
    break; 
  case 'a':
    cout << "Airbrush mode\n";
    nMode = MODE_AIRBRUSH;
    nGotStart = 0;
    break; 
  case 'd':
    if (nDelay) {
      nDelay = 0;
      cout << "Pixel delay OFF\n";
    }
    else {
      nDelay = 1;
      cout << "Pixel delay ON\n";
    }
    break; 
  case 'b':
    if (nPixelSize == SMALL_PIX_SIZE)
      nPixelSize = BIG_PIX_SIZE;
    else
      nPixelSize = SMALL_PIX_SIZE;
    glPointSize((GLfloat)nPixelSize);
    glClear(GL_COLOR_BUFFER_BIT);
    nGotStart = 0;
    numPixelsX = screenWidth / nPixelSize;
    numPixelsY = screenHeight / nPixelSize;
    cout << "Pixel size now: " << nPixelSize << endl;
    break; 
  case 'x':
    glClear(GL_COLOR_BUFFER_BIT);
    nGotStart = 0;
    break; 
  case 'q':
      exit(1);
    break;
  }
}


// Main function
int main(int argc, char** argv) {

  cout << startMessage;
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  glutInitWindowSize(screenWidth, screenHeight);
  glutInitWindowPosition(100, 100);
  glutCreateWindow(windowName);
  glutDisplayFunc(redraw);
  glutMouseFunc(mouseClickCallback);
  glutMotionFunc(mouseDragCallback);
  glutKeyboardFunc(keyDownCallback);
  glutReshapeFunc(reshape);
  initialize();
  if (argc > 1) {
    fileFound = 1; parseFile = argv[1];
  }
  glutMainLoop();
  return 0;
}



//***************************************************************************
// Parsing function
//***************************************************************************

void parse( const char* filename ) {

  ifstream ifs(filename);
  if (!ifs.is_open()) {
    cout << "Failed to open file: " << filename << endl;
    return;
  }
  parsing = 1;

  string next;
  int x,y;
  int tx, ty;
  ifs >> next;
  while ( !ifs.eof() ) {

    // Handle color change
    if ( next == "COLOR" ) {
      ifs >> x;
      keyDownCallback(x + '0',0,0);
    }

    else if ( next == "A" ) {

      // parse an airbrushed point
      ifs >> x >> y;
      if (nMode != MODE_AIRBRUSH) keyDownCallback('A', 0, 0);
      mouseClick(x, y);

    }

    else if ( next == "P" ) {

      // parse a point
      ifs >> x >> y;
      if (nMode != MODE_POINTS) keyDownCallback('P', 0, 0);
      mouseClick(x, y);

    }

    else if ( next == "L" ) {

      // parse a line
      ifs >> x >> y >> tx >> ty;
      if (nMode != MODE_LINES) keyDownCallback('L', 0, 0);
      mouseClick(x, y);
      mouseClick(tx, ty);

    }

    else if ( next == "C" ) {

      // parse a circle
      ifs >> x >> y >> tx;
      if (nMode != MODE_CIRCLES) keyDownCallback('C', 0, 0);
      mouseClick(x, y);
      mouseClick(x + tx, y);

    }

    else if ( next == "Y" ) {

      // parse a polyline
      ifs >> x >> y;
      if (nMode != MODE_POLYLINES) keyDownCallback('Y', 0, 0);
      mouseClick(x, y);

      string buf;
      getline(ifs,buf,'\n');
      stringstream ss(buf);
      while (!ss.eof()) {
        ss >> tx >> ty;
        mouseClick(tx, ty);
      }

    }

    else if (next == "END") {
      break;
    }

    else if ( next == "R" ) {

      // parse a rectangle
      ifs >> x >> y >> tx >> ty;
      if (nMode != MODE_RECTANGLES) keyDownCallback('R', 0, 0);
      mouseClick(x, y);
      mouseClick(tx, ty);

    }

    else if ( next == "F" ) {

      // parse a floodfill
      ifs >> x >> y;
      if (nMode != MODE_FLOODFILL) keyDownCallback('F', 0, 0);
      mouseClick(x, y);

    }

    // grab the next token
    ifs >> next;
  }

  parsing = 0;
}

