/*****
 *
 * rubix.cpp
 *
 * CS148 project 2
 *
 * Written by Dan Morris
 *
 *****/

#include <math.h>
#include "cs148.h"
#include <GL/glut.h>

// Make sure pi is defined
#ifndef M_PI
#define M_PI 3.14159
#endif

/***
 Free stuff we're giving you
***/

// A structure representing a camera
//
// A camera remembers where it is and where it's looking
struct camera_type {
  float x,y,z;
  float ax,ay,az;

  // Sets up the camera at the correct position
  void setup() {
    glLoadIdentity();
    glRotatef(360-ay,0,1,0);
    glTranslatef(-x,-y,-z);
  }
};

// The one and only camera you'll be using
camera_type camera;

// A structure representing a colored material
struct material {
  float specular[4];
  float ambient [4];
  float diffuse [4];
  float shininess;
  material(float r, float g, float b) {
    specular[0] = ambient[0] = diffuse[0] = r;
    specular[1] = ambient[1] = diffuse[1] = g;
    specular[2] = ambient[2] = diffuse[2] = b;
    specular[3] = ambient[3] = diffuse[3] = 1.0;
    shininess = 100.0;
  }
  material() { }
};


// Some materials you can use in your program
material MAT_WHITE (1.0,1.0,1.0);
material MAT_GRAY  (0.5,0.5,0.5);
material MAT_BLUE  (0.1,0.1,0.6);
material MAT_GREEN (0.0,1.0,0.0);
material MAT_RED   (0.6,0.1,0.1);
material MAT_YELLOW(0.5,0.5,0.0);

// You can use this to change the current rendering material
void SetMaterial(material m);

// Draws an x,y,z coordinate frame (call this to help you
// find your current origin)
void draw_axes();

/******
GLOBALS
******/

// You'll probably want to keep track of which axis is
// rotating, or which axis will be rotated the next
// time the user presses a relevant button

// You'll probably need to keep track of how long 
// the segment has been spinning so you can rotate
// it properly and so you know when it's done.

/***
 Functions you need to fill in
***/

struct Block {

  // A block knows what color it is
  material m;

  // A default constructor
  Block() { }

  // You can give other properties to blocks...
};


// My big array of blocks
Block blocks[3][3][3];


// A function (that you need to fill in) that sets up your
// cube
void InitializeRubix(void) {

  // Initialize all of your blocks
}


// A function (that you need to fill in) that draws your robot
void DrawRubix(void) {

  // Draw all of your blocks, taking the relevant rotations into
  // account

  // We just draw a cube here so something shows up when you
  // first run your program...
  glPushMatrix();	
  SetMaterial(MAT_RED);
  glutSolidCube(0.9);
	glPopMatrix();

}


// A function (that you need to fill in) to handle keystrokes
void keyboard(unsigned char key, int x, int y) {

}


// An idle function (that you need to fill in) to do animation
void idle() {

  // Figure out how much time has elapsed

  // Update the correct rotation variable (wherever you store
  // your rotation)

  // See whether you're done rotating this segment

  // If so:

    // Fix your array to reflect the new positions of the blocks

    // Reset all your rotation angles and other variables that have
    // to do with animation

}



/************************
 Functions we've given you... you don't need to worry about
 anything below this point (although you're encouraged to
 poke around).
*************************/

// Resize and initialize the GL window
GLvoid Reshape(GLint width, GLint height) {

  glViewport(0,0,width,height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();

  // Set up a perspective projection based on the window's aspect ratio
  gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,50.0f);

  // Back to modelview mode to be nice
  glMatrixMode(GL_MODELVIEW);             
  glLoadIdentity();

}

// Initialize OpenGL
int InitGL(GLvoid) {
  
  // Enable smooth shading
  glShadeModel(GL_SMOOTH);              

  // black Background
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);       
  glEnable(GL_DEPTH_TEST);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  glFrontFace(GL_CCW);
  glPolygonMode(GL_FRONT,GL_FILL);
  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);
  
  // Set up a nice camera position
  camera.z = 10.0;
  camera.y = 0.0;

  // Set up our cubes...
  InitializeRubix();
  
  // Initialization went fine
  return true;
}


// Turn the light on
void lights(void){

  // The position of the light
  GLfloat position[] =  {0.0, 0.0, 3.0, 1.0};

  GLfloat color[] = {1,1,1,1};
  GLfloat acolor[] = {0,0,0,1};
  

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  
  glLightfv(GL_LIGHT0, GL_POSITION, position);
  glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 80.0);
  glLightfv(GL_LIGHT0, GL_AMBIENT, acolor);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, color);
  glLightfv(GL_LIGHT0, GL_SPECULAR, color);

  // Show the user where the light is...
  /*
  glPushMatrix();
  glTranslatef(position[0],position[1],position[2]);
  glDisable(GL_LIGHTING);
  glColor3f(1,1,1);
  glutWireCube(0.1);
  glEnable(GL_LIGHTING);
  glPopMatrix();
  */

  // Normally we wouldn't do this since it's really slow, but we want
  // to let you use scales in this assignment
  glEnable(GL_NORMALIZE);
}


// Set the current material 
void SetMaterial(material m) {

  glMaterialfv(GL_FRONT, GL_SPECULAR,  m.specular);
  glMaterialf (GL_FRONT, GL_SHININESS, m.shininess);
  glMaterialfv(GL_FRONT, GL_AMBIENT,   m.ambient);
  glMaterialfv(GL_FRONT, GL_DIFFUSE,   m.diffuse);
  glColor4f(m.diffuse[0],m.diffuse[1],m.diffuse[2],1.0);
}


void display(void) {

  // Clear screen and depth buffer
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  // Set up the camera
  camera.setup();

  // Set up lights
  lights();

  // Draw the cube
  DrawRubix();

  // Show the result to the user
  glutSwapBuffers();
  
}



// Draws an axis vector (line + cone) along the z axis
void draw_axis(double length) {
	glPushMatrix();
	glBegin(GL_LINES);
		glVertex3d(0,0,0); 
		glVertex3d(0,0,length); 
	glEnd();
	glTranslated(0,0, length-0.2);
	glutSolidCone(0.04, 0.2, 12, 9);
	glPopMatrix();
}


void draw_axes() {

  #define AXIS_LENGTH 3.0

  // draw the axes
  glDisable(GL_LIGHTING);
  glLineWidth(2.0);

  // Draw the z axis
	glColor3d(0, 0, 1.0);
	draw_axis(AXIS_LENGTH);

  // Draw the x and y axes
	glPushMatrix();
	  glRotated(90, 0, 1, 0);
	  glColor3d(1., 0, 0);
	  draw_axis(0.5);
	  glRotated(-90, 1, 0, 0);
	  glColor3d(0, 1., 0);
	  draw_axis(0.5);
	glPopMatrix();
	
  glEnable(GL_LIGHTING);

}

int main(int argc, char** argv) {

  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
  glutInitWindowSize(640,480);
  glutInitWindowPosition(100,150);
  glutIdleFunc(idle);
  glutCreateWindow("TOBOR");
  glutDisplayFunc(display);
  glutReshapeFunc(Reshape);
  glutKeyboardFunc(keyboard);
  InitGL();
  glutMainLoop();

  return 0;
}
