// mesh.h: interface for the mesh class.
//
// http://cggmwww.csie.nctu.edu.tw/courses/cgu/2002/prog1.htm
//
// Jung Hong Chuang
//
//////////////////////////////////////////////////////////////////////

#ifndef _OBJ_MESH_H_
#define _OBJ_MESH_H_

#include <stdio.h>
#include <stdlib.h>
#include <map>
#include <vector>
#include <string>

#ifdef WIN32
#pragma warning(disable: 4786)
#endif

using namespace std;

class material
{
public:
  float Ka[4];
  float Kd[4];
  float Ks[4];
  float Ns; // shininess
  char texture_filename[512];

  material()
  { 
    for (int i=0;i<4;i++)
      Ka[i] = Kd[i] = Ks[i] = 1;
    Ns = 0;
    texture_filename[0] = '\0';
  }
};

class Vertex    
{
public:
  int v;    // vertex (index of vList)
  int n;    // normal (index of nList)
  int t;    // texture (index of tList)
  int m;    // material (index of material)
  Vertex() {};
  Vertex(int v_index, int n_index, int t_index=0, int m_index=0)
  {
    v = v_index;
    n = n_index;
    t = t_index;
    m = m_index;
  }
};

class Vec3
{
public:
  float ptr[3];
  Vec3 (float *v) 
  {
    for (int i=0;i<3;i++)
      ptr[i] = v[i];
  }
  float& operator[](int index)
  {
    return ptr[index];
  }
};

class FACE    
{
public:
  Vertex v[3]; // 3 vertices for each face
  FACE (Vertex &v1, Vertex &v2, Vertex &v3) 
  {
    v[0] = v1; 
    v[1] = v2;
    v[2] = v3;
  }
  Vertex& operator[](int index)
  {
    return v[index];
  }
};


class mesh  
{
  
public:

  /////////////////////////////////////////////////////////////////////////////
  // Loading Object
  /////////////////////////////////////////////////////////////////////////////

  FILE  *scenef, *materialf;
  string  s_file, m_file;
  char  mat_file[50];   // material file name

  int   matTotal; // total material 
  map<string,int> matMap;   // matMap[material_name] = material_ID
  material  mat[100]; // material ID 

  vector<Vec3> vList;    // Vertex List (Position) - world cord.
  vector<Vec3> nList;    // Normal List
  vector<Vec3> tList;    // Texture List
  vector<FACE> faceList; // Face List

  int vTotal, tTotal, nTotal, fTotal;

  void LoadMesh(string scene_file);
  void LoadMat(string mat_file);

  mesh();
  mesh(const char* obj_file);
  virtual ~mesh();

  void Init(const char* obj_file);
};

#endif
