/**************

----------------------------------
Dan Morris
dmorris@cs.stanford.edu
http://techhouse.brown.edu/dmorris
----------------------------------

**************/

// car_control.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"

#define MAIN_INCLUDE
#include "globals.h"
#undef MAIN_INCLUDE

#include "car_control.h"
#include "car_controlDlg.h"
#include "joystickio.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCar_controlApp

BEGIN_MESSAGE_MAP(CCar_controlApp, CWinApp)
	//{{AFX_MSG_MAP(CCar_controlApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCar_controlApp construction

CCar_controlApp::CCar_controlApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCar_controlApp object

CCar_controlApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CCar_controlApp initialization

BOOL CCar_controlApp::InitInstance()
{
	
	AfxEnableControlContainer();

	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	AllocConsole();
  
  g_cjio = 0;
  g_mainDialog = new CCar_controlDlg;
  m_pMainWnd = g_mainDialog;
  g_mainDialog -> Create(IDD_CAR_CONTROL_DIALOG,NULL);
  g_mainWnd = g_mainDialog->m_hWnd;

	return TRUE;
}

void CCar_controlApp::handle_js_event() {

  // Tell the directinput wrapper to fetch the device state
  g_cjio->pollState();

  // joystick coordinates range from -100 to +100
  float x = g_cjio->lastx;
  float y = g_cjio->lasty;

  // slider coordinates range from 0 to 200
  g_mainDialog->m_horizontal_slider.SetPos((int)x+100);
  g_mainDialog->m_vertical_slider.SetPos((int)(-y)+100);

  // car coordinates range from -1 to 1
  g_cdcar->set_speed(y/100.0f);
  g_cdcar->set_turn(x/100.0f);
  
}
  
// This is where an MFC application starts executing
int CCar_controlApp::Run() {

  g_cdcar = 0;

  MSG msg;
  
  // Create a semaphore to be signaled by directinput
  g_js_event = ::CreateEvent(0,0,0,"joystick_event");

  if (g_js_event == 0) {
    _cprintf("Error creating joystick notification event...\n");
    _getch();
    ExitProcess(1);
  }

  // Create our directinput wrapper
  g_cjio = new CJoystickIO(g_js_event); 

  // joystick coordinates will range from -100 to +100
  g_cjio->scale_factor[0] = 0.1;
  g_cjio->scale_factor[1] = -0.1;
  g_cjio->offset[0] = g_cjio->offset[1] = 0;

  // Start up directinput
  int result = g_cjio->startDevice();

  if (result < 0) {
    _cprintf("Could not start joystick device; using keyboard mode...\n");
    g_keyboard_mode = 1;
  }

  else {
    g_keyboard_mode = 0;
  }

  g_mainDialog->update_device_list();

  // Note that the car is not initialized yet; we wait for the
  // user to click on the "start car" button
  g_cdcar = new CDigitalCar();

  DWORD dwResult;
  DWORD dwWait = INFINITE;

#define TIMER_ID 100

  // We make the timer more frequent if we need to poll the
  // dinput device for events (because it doesn't support
  // notification)
  DWORD timerval =
    (g_cjio->m_polled_device == STATUS_POLL)?1:10;
  ::SetTimer(g_mainWnd,TIMER_ID,timerval,0);

  int quit = 0;
    
  while (quit==0) {

    g_mainDialog->update_leds(g_cdcar->get_bitstate());

    // Block until a message or joystick event occurs
    dwResult = 
      MsgWaitForMultipleObjects(1, &g_js_event, FALSE, dwWait, QS_ALLEVENTS); 
    
    switch(dwResult) {

    // joystick event
    case WAIT_OBJECT_0:
       handle_js_event();
       break;
    
    // A message has arrived
    case WAIT_OBJECT_0+1:

      // Process all available messages
      while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
        if (msg.message == WM_QUIT) { 
          quit = 1;           
        } 
        TranslateMessage(&msg); 

        if (msg.message == WM_TIMER) {
          if (g_cjio->m_polled_device == STATUS_POLL)
            handle_js_event();
          g_cdcar->timer();

          // This will reset the timer, and if the type of
          // device has changed, the timeout interval will change
          // appropriately.
          DWORD timerval =
            (g_cjio->m_polled_device == STATUS_POLL)?1:10;
          ::SetTimer(g_mainWnd,TIMER_ID,timerval,0);

        }

        else if (msg.message == WM_KEYDOWN &&
                 msg.wParam >= VK_LEFT &&
                 msg.wParam <= VK_DOWN) {

          if (g_keyboard_mode) {
            
            switch(msg.wParam) {

            case VK_LEFT:
              g_cjio->lastx -= 10.0;
              if (g_cjio->lastx < -100) g_cjio->lastx = -100;
              break;
            case VK_UP:
              g_cjio->lasty += 10.0;
              if (g_cjio->lasty > 100) g_cjio->lasty = 100;
              break;
            case VK_DOWN:
              g_cjio->lasty -= 10.0;
              if (g_cjio->lasty < -100) g_cjio->lasty = -100;
              break;
            case VK_RIGHT:
              g_cjio->lastx += 10.0;
              if (g_cjio->lastx > 100) g_cjio->lastx = 100;
              break;
            }
            
            
            handle_js_event();
          }
        }

        else DispatchMessage(&msg); 
      }      
      break; 

    case WAIT_TIMEOUT:
      _cprintf("warning: wait timeout\n");
      break;

    default:
      _cprintf("warning: wait abandoned\n");
      break;
    }

  }

  g_cjio->stopDevice();
  delete g_cjio;
  delete g_cdcar;

  return FALSE;
}
