/**************

----------------------------------
Dan Morris
dmorris@cs.stanford.edu
http://techhouse.brown.edu/dmorris
----------------------------------

**************/

#include "stdafx.h"
#include "car_control.h"
#include "car_controlDlg.h"
#include "globals.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CCar_controlDlg::CCar_controlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCar_controlDlg::IDD, pParent) {
	//{{AFX_DATA_INIT(CCar_controlDlg)
	m_parport_edit = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

  last_data = 0x0;

}

void CCar_controlDlg::DoDataExchange(CDataExchange* pDX) {
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCar_controlDlg)
	DDX_Control(pDX, IDC_LED0, m_led_0);
  DDX_Control(pDX, IDC_LED1, m_led_1);
  DDX_Control(pDX, IDC_LED2, m_led_2);
  DDX_Control(pDX, IDC_LED3, m_led_3);
  DDX_Control(pDX, IDC_LED4, m_led_4);
  DDX_Control(pDX, IDC_LED5, m_led_5);
  DDX_Control(pDX, IDC_LED6, m_led_6);
  DDX_Control(pDX, IDC_LED7, m_led_7);

	DDX_Control(pDX, IDC_INPUTDEV_COMBO, m_inputdev_combo);
	DDX_Control(pDX, IDC_VERTICAL_SLIDER, m_vertical_slider);
	DDX_Control(pDX, IDC_HORIZONTAL_SLIDER, m_horizontal_slider);
	DDX_Text(pDX, IDC_PARPORT_EDIT, m_parport_edit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCar_controlDlg, CDialog)
	//{{AFX_MSG_MAP(CCar_controlDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_STARTCAR_BUTTON, OnStartCarButton)
	ON_CBN_EDITCHANGE(IDC_INPUTDEV_COMBO, OnDeviceComboChange)
	ON_CBN_SELCHANGE(IDC_INPUTDEV_COMBO, OnDeviceComboChange)
	ON_CBN_DROPDOWN(IDC_INPUTDEV_COMBO, OnDeviceComboDropDown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CCar_controlDlg::OnInitDialog() {
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
  // Initialize the sliders to look nice
  m_horizontal_slider.SetTicFreq(20);
  m_vertical_slider.SetTicFreq(20);

	m_horizontal_slider.SetRange(0,200,1);
  m_vertical_slider.SetRange(0,200,1);

  m_horizontal_slider.SetPos(100);
  m_vertical_slider.SetPos(100);

  char buf[10];
  sprintf(buf,"%x",DEF_PARPORT_ADDR);

  m_parport_edit = buf;

  if (g_cjio) update_device_list();

  led_array[0] = &m_led_0;
  led_array[1] = &m_led_1;
  led_array[2] = &m_led_2;
  led_array[3] = &m_led_3;
  led_array[4] = &m_led_4;
  led_array[5] = &m_led_5;
  led_array[6] = &m_led_6;
  led_array[7] = &m_led_7;

  for(int i=0; i<8; i++) {
    led_array[i]->SetImage(IDB_GREENLED,15);
  }

  UpdateData(FALSE);
  return TRUE;
}

void CCar_controlDlg::update_device_list() {

  m_inputdev_combo.ResetContent();

  if (g_cjio == 0) return;

  g_cjio->enumerate_devices();

  std::list<DIDEVICEINSTANCE>::iterator iter =
    g_cjio->enumerated_devices.begin();
  for(;iter!=g_cjio->enumerated_devices.end();iter++) {
    m_inputdev_combo.AddString((*iter).tszInstanceName);
  }

  m_inputdev_combo.AddString("Keyboard");

  m_inputdev_combo.SetCurSel(0);

  // Set the edit parts of the combo boxes to be read-only.
  CEdit* pComboEdit=(CEdit*)(m_inputdev_combo.GetWindow(GW_CHILD ));
  pComboEdit->EnableWindow( TRUE );
  pComboEdit->SetReadOnly();
}

// Default mfc wizard method
void CCar_controlDlg::OnPaint() {
	if (IsIconic())	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


// Default mfc wizard method
HCURSOR CCar_controlDlg::OnQueryDragIcon() {
	return (HCURSOR) m_hIcon;
}


void CCar_controlDlg::OnClose() {
	
  delete g_mainDialog;
  FreeConsole();	
	exit(0);
	CDialog::OnClose();

}


// Called when the user clicks the button to start up the car
void CCar_controlDlg::OnStartCarButton() {

  UpdateData(TRUE);

  int port;
  int result = sscanf((LPCSTR)m_parport_edit,"%x",&port);

  if (result < 1) {
    _cprintf("Could not parse parallel port address... type a nice hex value please.\n");
    return;

  }

  result = g_cdcar->initialize(port);

  if (result < 0) {
    _cprintf("Warning: could not initialize digital car on port 0x%x\n",port);    
  }

  else {
    _cprintf("Initialized car on port 0x%x\n",port);
  }
}

void CCar_controlDlg::OnDeviceComboChange() {

  UpdateData(TRUE);
  int index = m_inputdev_combo.GetCurSel();
  char text[1000];
  m_inputdev_combo.GetLBText(index,text);

  update_device_list();

  if (strcmp(text,"Keyboard")==0) {
    g_cjio->releaseDevice();
    g_keyboard_mode = 1;
  }
  
  else {
    g_keyboard_mode = 0;
    g_cjio->startDevice(text);
  }

  if (index < m_inputdev_combo.GetCount())
    m_inputdev_combo.SetCurSel(index);
  else 
    m_inputdev_combo.SetCurSel(0);


  
}

void CCar_controlDlg::OnDeviceComboDropDown() {
  update_device_list();
}


void CCar_controlDlg::update_leds(unsigned char data) {

  if (data == last_data) return;

  last_data = data;

  for(int i=0; i<8; i++) {

    led_array[i]->Depress((data & (1<<i))?1:0);
    
  }

}
  