// (c) Copyright 2003 Cyberkinetics, Inc.
//
// $Workfile: celapsed.h
// $Archive: 
// $Revision: 1.0
// $Date: 2003.03.01
// $Author: Dan Morris
// 
// $History: header added on 2003.03.01
// 
// $Keywords: 

/***********

  This class provides a nice wrapper around the Intel high-performance
  counter, so all times in TG2 can be represented in seconds.  This class
  is used both to access relative times (using Begin() and End(); e.g. the
  time since the beginning of an experiment) and to access absolute time
  (using GetTime()).

***********/

#ifndef _C_ELAPSED_H_
#define _C_ELAPSED_H_

class CElapsed
  {
  private :
    int Initialized;
      __int64 Frequency;
      __int64 BeginTime;

  public :
    CElapsed()      // constructor
    {
      // get the frequency of the counter
      Initialized = QueryPerformanceFrequency( (LARGE_INTEGER *)&Frequency );
      if (Initialized == 0) {
        _cprintf("Very bad error: could not initialize celapsed clock\n");
      }
    }

    int Begin()    // start timing
      {
      if( ! Initialized )
        return 0;   // error - couldn't get frequency

      // get the starting counter value
      return QueryPerformanceCounter( (LARGE_INTEGER *)&BeginTime );
      }

    double End()    // stop timing and get elapsed time in seconds
      {
      if( ! Initialized )
        return 0.0; // error - couldn't get frequency

      // get the ending counter value
      __int64 endtime;
      QueryPerformanceCounter( (LARGE_INTEGER *)&endtime );

      // determine the elapsed counts
      __int64 elapsed = endtime - BeginTime;

      // convert counts to time in seconds and return it
      return (double)elapsed / (double)Frequency;
      }

    int Available()  // returns true if the perf counter is available
      { return Initialized; }

    __int64 GetFreq() // return perf counter frequency as large int
      { return Frequency; }

    double GetTime() {
      if( !Initialized ) {
        _cprintf("Accessing unitialized celapsed...\n");
        return 0.0; // error - couldn't get frequency
      }

      // get the ending counter value
      __int64 curtime;
      QueryPerformanceCounter( (LARGE_INTEGER *)&curtime );

      return (double)curtime / (double)Frequency;
    }

    double GetStartTime() {
      if( ! Initialized )
        return 0.0;

      return (double)(BeginTime) / (double)(Frequency);
    }

  };

#endif