/**************

----------------------------------
Dan Morris
dmorris@cs.stanford.edu
http://techhouse.brown.edu/dmorris
----------------------------------

**************/

#ifndef _DIGITAL_CAR_H_
#define  _DIGITAL_CAR_H_

/* 
   This defines the pins on the parallel port that control each
   of the car's controls.  Note that these are the numbers of the
   _data bits_, not the pins.  Pin 1 on the parallel port is the
   strobe bit, pin 2 is data bit 0, and pin _3_ is data bit 1
   (so this should be connected to "back" on the remote control").
*/
typedef enum {
  SPEED_BACK=1, TURN_RIGHT, TURN_LEFT, SPEED_FORWARD
} car_pins;


class CDigitalCar {

public:

  CDigitalCar();
  virtual ~CDigitalCar();

  // Set to one once we've opened communication with the parallel port
  int m_initialized;

  /* 
     Speed should range from -1 to 1, where 1.0 is full-speed
     forward.  Returns the _actual_ speed sent to the car.
  */
  float set_speed(float speed);

  /* 
     Turn should range from -1 to 1, where 1.0 is a maximal
     right turn.  Returns the _actual_ speed sent to the car.
  */
  float set_turn(float turn);

  // Returns 0 for success, <0 for failure
  int initialize(int portnum = 0x378);

  int uninitialize();

  float getspeed() { return speed; }
  float getturn() { return turn; }

  // If you want to use the "pulsing" functionality, call this
  // function every few milliseconds.
  void timer();
  
  // Use this to enable/disable pulsing to simulate speed control
  void set_pulse(int enable) {
    pulse = enable;
  }

  unsigned char get_bitstate() { return bitstate; }

private:

  // The i/o port we're writing to
  int portnum;

  // The current state of the bits on the parallel port
  unsigned char bitstate;

  // Our speed; -1.0 is full back, 1.0 is full forward
  float speed;

  // Our direction; -1.0 is full left, 1.0 is full right
  float turn;

  /* This is set to one if we should be pulsing the car to
     simulate speed control. */
  int pulse;

  // The last system clock time (in seconds) when we last
  // changed a pin that's being pulsed
  float lastpulse;
};

#endif