/**************

----------------------------------
Dan Morris
dmorris@cs.stanford.edu
http://techhouse.brown.edu/dmorris
----------------------------------

**************/

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include "digitalcar.h"

/* Make sure that all global variables can be included
   from anywhere but only get allocated once. */
#ifndef MAIN_INCLUDE
#define SCOPE extern
#else
#define SCOPE
#endif

#ifndef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION 0x0800
#endif

class CCar_controlDlg;
class CJoystickIO;

// The main dialog window
SCOPE CCar_controlDlg* g_mainDialog;
SCOPE HWND g_mainWnd;

// A synchronization object we use to signal directinput events
SCOPE HANDLE g_js_event;

// Our interface to the joystick
SCOPE CJoystickIO* g_cjio;

// Our interface to the car
SCOPE CDigitalCar* g_cdcar;

SCOPE int g_keyboard_mode;

#include <dinput.h>

// Nice wrappers to make sure we don't delete or Release() null
#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#define SAFE_RELEASE(p) { if(p) { (p)->Release(); (p)=NULL; } }

// A global handle to direct input
SCOPE LPDIRECTINPUT8 g_pDirectInput;

#include <conio.h>

/*
   The default parallel port address.  You ask: "Why not 0x378?"
   My goal for this project was to control the car via a
   dance-dance revolution pad, which I had connected via the 
   parallel port.  I also wanted to control the car over the 
   parallel port, so I installed another parallel port (it
   cost $5 on pricewatch.com).  The driver that talks to the
   PS2 controller over the parallel port only knows about 0x378,
   so I put the car on the new parallel port, which is at
   0xec78.
*/
// #define DEF_PARPORT_ADDR 0xec78

// The version I put on the web will actually default to 0x378
#define DEF_PARPORT_ADDR 0x378

#endif