/***********
 
   The interface to the PortTalk library, which allows access to
   the parallel port in NT.  The library is publicly available, and
   author information is at the top of the .cpp file.  This header
   file did not ship with the library; I wrote this to nicely wrap
   up the .cpp file.

************/

#ifndef _PT_IOCTL_H_
#define _PT_IOCTL_H_

#include <winioctl.h>
#include <winsvc.h>
#include "porttalk_IOCTL.h"

/* Initialize the library; tries to load the PortTalk driver if
   it hasn't been loaded.  Returns -1 for failure, 0 for success.

   This should be idempotent; that is, it closes the driver before
   attempting to re-open it. */
int OpenPortTalk(void);

// Close the connection to the PortTalk driver
void ClosePortTalk(void);

// Write a byte out to a specified address in the CPU's I/O space
void outportb(unsigned short PortAddress, unsigned char byte);

// Read a byte from a specified address in the CPU's I/O space
unsigned char inportb(unsigned short PortAddress);

void InstallPortTalkDriver(void);
unsigned char StartPortTalkDriver(void);

/* Macros that let us use old-style inp and outp for communicating with 
   the parallel port. */
//#define    inp(PortAddress)         inportb(PortAddress)
//#define    outp(PortAddress, Value) outportb(PortAddress, Value)

#endif