% First manually define all the bounding boxes for a few samples of each letter
% in an image of some text.
letters = getletters('letter.1.2.front.bmp');

% Now for each letter, define a few important points that live on the contour of
% that letter.
letterpoints = getpoints(letters,'letter.1.2.front.bmp');

% Now reformat those countours into an 'alphabet', which can be used to actually
% render synthesized handwriting.
alphabet = makealphabet(letterpoints);

% Generate some handwriting from some text. 
g = gentext(alphabet,'This is a test.  Is this handwriting or not...');

% Display it on the screen
drawlines(g);

