% function [ lettertable ] = getpoints( lettertable, filename )
%
% A friendly way to go through all the bounding boxes you defined when you ran
% 'getletters' and define points for each one.  See the README for more instructions.
%
function [ lettertable ] = getpoints( lettertable, filename )

if (nargin < 2)
    fprintf(1,'Syntax: getpoints(lettertable, filename)\n');
    return;
end

imgdata = imread(filename);

if (length(size(imgdata)) < 3)
    imgdata = repmat(imgdata,[1 1 3]);
end

if (~(exist('imgdata')))
    fprintf(1,'Error reading image file %s\n\n',filename);
    return;
end

fprintf(1,'Click points to define your spline; use the green box\n');
fprintf(1,'to start a new spline and the red box to finish a letter.\n');
fprintf(1,'Use the blue box to define a baseline and finish the letter.\n');

finished = 0;

canceledletters = [];
numcancels = 0;

for(i=1:length(lettertable))
  
  if (finished == 1)
    break;
  end
  
  cur = lettertable{i};
  curpoints = ceil(cur.points);
  hold off;
  image(imgdata(curpoints(2):curpoints(4),curpoints(1):curpoints(3),:));
  axis image;
  colormap(gray);
  hold on;
  
  % Green box
  fill([1 1 10 10],[1 10, 10, 1],[0 1 0]);
  % Red box
  fill([11 11 20 20],[1 10, 10, 1],[1 0 0]);
  % Blue box
  fill([21 21 30 30],[1 10, 10, 1],[0 0 1]);

  curspline = [];
  splinecount = 1;
  splineset = {};
  done = 0;
  pointcount = 0;
  baseline = 0;
  useSpline = 1;
  
  while(done == 0)
    [x y button] = ginput(1);
    
    if (button > 1)
        fprintf(1,'Cancelling letter...\n');
        useSpline = 0;
        curspline = [];
        done = 1;
        numcancels = numcancels+1;
        canceledletters(numcancels) = i;
        continue;
    end
    
    % Done with this spline
    if (x <= 10 & y < 10)
      splineset{splinecount} = curspline;
      curspline = [];
      splinecount = splinecount + 1;
      pointcount = 0;
      continue;
    end
    
    % Done with this letter
    if (x <= 20 & y < 10)
      splineset{splinecount} = curspline;
      curspline = [];
      done = 1;
      continue;
    end
    
    % Done with this letter, but get a baseline first
    if (x <= 30 & y < 10)
      splineset{splinecount} = curspline;
      curspline = [];
      done = 1;
      fprintf(1,'Please click on the baseline point...\n');
      [x y] = ginput(1);
      baseline = y;
      continue;
    end
    
    pointcount = pointcount + 1;
    
    % An 'emergency rescue' technique
    if (pointcount > 20)
      splineset{splinecount} = curspline;
      curspline = [];
      finished = 1;
      done = 1;
      continue;
    end
    
    curspline(pointcount,:) = [x y];
    plot(x,y,'*');
    if (pointcount > 1)
      l = line([x curspline(pointcount-1,1)],[y curspline(pointcount-1,2)]);
      set(l,'Linewidth',1);
    end
    
  end % the current character

  if (useSpline == 1)
    lettertable{i}.splines = splineset;
  
    hold off;
    %close all;
  
    if (baseline > 0)
      lettertable{i}.baseline = baseline;
    else
      lettertable{i}.baseline = 0;
    end
  
  end
    
  hold off;

end

% Take canceled letters out of the output

oldtable = lettertable;
lettertable = {};
numletters = 0;

for(i=1:length(oldtable))
  if (isempty(find(canceledletters == i)))
      numletters = numletters + 1;
      lettertable{numletters} = oldtable{i};
  end
end