% function [ alphabet ] = makealphabet( lettertable )
%
% Takes the output of 'getletters' and 'getpoints' and turns it into 
% an 'alphabet', suitable for passing to 'gentext'.
%
function [ alphabet ] = makealphabet( lettertable )

alphabet = {};
letcount = 0;
letters = [];

for(i=1:length(lettertable))
  cur = lettertable{i};
  let = cur.letter + 0;
  if (let > length(alphabet) | isempty(alphabet{let}))
    alphabet{let} = cur;
    letcount = letcount + 1;
    letters(letcount) = let;
  else
    alphabet{let} = [alphabet{let} cur];
  end
end

fprintf(1,'Your alphabet contains :\n');
fprintf(1,char(letters));


