% function removeletter(alphabet,letter,index)
%
% removes one instance of one letter from the given alphabet.  For
% example, to remove the first 'g' in the alphabet 'myletters', I would do :
% 
% myletters = removeletter(myletters,'g',1);
%
% index can also be an array of indices to remove.
%
function [newalphabet] = removeletter(alphabet,letter,index)

% convert char to index
cur = letter + 0;

len = length(alphabet{cur});

if (len == 0)
    fprintf(1,'\nNo samples for letter %c (%d)\n\n',letter,cur);
    return;
end

if (max(index) > len | min(index) < 1)
    fprintf(1,'\nOnly %d samples for letter %c (%d)\n\n',len,letter,cur);
    return;
end

newalphabet = alphabet;

% generate a list of indices that we want to _keep_
keepinds = [];
for(i=1:len)
    % if we're not throwing this letter out
    if (isempty(find(index==i)))
        keepinds(end+1) = i;
    end
end

% remove the letter
newalphabet{cur} = newalphabet{cur}(keepinds);
