function showletter(alphabet, letter)

curx = 0;
cury = 0;

textlines = [];
linecount = 0;

len = length(alphabet{letter+0});
for(i=1:len)
    if (len == 1)
        curletter = alphabet{letter+0};
    else
        curletter = alphabet{letter+0}(i);
    end
    
    s = splineletter(curletter);
    
    % Now we have a letter struct, we need to make a spline from it
  s = splineletter(curletter);
  
  % s is now a cell array of double arrays, containing spline points
  
  minx = 10000;
  maxx = 0;
  
  % first find the minimum x in the letter
  for(j=1:length(s))
    curpoints = s{j};
    lminx = min(curpoints(1,:));
    lmaxx = max(curpoints(1,:));
    
    minx = min(lminx,minx);
    maxx = max(lmaxx,maxx);
  end
  
  letterwidth = maxx - minx;
  
  % now actually make the letter
  
  % for each spline
  for(j=1:length(s))
    curpoints = s{j};
    
    % for each point
    for(k=1:length(curpoints)-1)
      curline = [curpoints(1,k) curpoints(2,k) curpoints(1,k+1) curpoints(2,k+1)];
      
      x1 = curline(1);
      y1 = curline(2);
      x2 = curline(3);
      y2 = curline(4);
    
      x1 = x1 + curx - minx;
      x2 = x2 + curx - minx;
      
      y1 = y1 + cury;
      y2 = y2 + cury;
    
      linecount = linecount+1;
      textlines(linecount,:) = [x1 y1 x2 y2];
    end    
    
  end
  
  curx = curx + letterwidth + 50;
end

drawlines(textlines);