% function splines = splineletter(letterstruct)
%
% This is purely experimental; I initially tried to build splines among the points
% that define each letter, but I decided that just connecting them with lines was better.
%
% This is still something to play with at some point.  And it's a useful demo of how to
% make splines in Matlab.
%
% Should take a _single_ letterstruct, may return multiple splines
function splines = splineletter(letterstruct)

inputs = letterstruct.splines;

splines = {};

RANDFACT = .8;

maxy = 0;

for(i=1:length(inputs)) 
  points = inputs{i};
  localmaxy = max(points(:,2));
  if (localmaxy > maxy)
    maxy = localmaxy;
  end
end

if (letterstruct.baseline == 0)
  yoffset = 0;
else
  yoffset = letterstruct.baseline - maxy;  
end

for(i=1:length(inputs)) 

  points = inputs{i};

  for(j=1:size(points,1))
      r = (rand(1) * 2) - 1;
      points(j,1) = points(j,1) + r*RANDFACT;
      r = (rand(1) * 2) - 1;
      points(j,2) = points(j,2) + r*RANDFACT;
  end

  points(:,2) = maxy - points(:,2);

  x = points(:,1)';
  y = points(:,2)';
  
  y = y + yoffset;

  xy = [x;y]; df = diff(xy.').'; 
  t = cumsum([0, sqrt([1 1]*(df.*df))]); 
  %cv = csapi(t,xy);

  cv = cscvn(xy);
  % fnplt(cv,4), hold on, plot(x,y,'o'), hold off
  % fnplt(cv,8);
  splines{i} = fnplt(cv,8);
end
