/* 
   KBD_CALIBRATE

   Dan Morris
   dmorris@cs.stanford.edu

   An application to read keys from the palm keyboard and map them
   to windows keys.  Plug in the keyboard, then start this application.
   Press a key on the Palm keyboard, then press the correspoding
   key on the 'real' keyboard.  Do this for all keys you want mapped.

   This is used to generate the 'palmkey.ini' file that is used by
   the kbddrivewin program (which actually allows you to use the 
   Palm keyboard like a normal keyboard.

   Hard-coded to _append_ to a file called 'palmkey.ini' in the current
   directory.  So if you want to create the mapping from scratch
   delete this file first.

   This program is pretty ghetto; you have to close the window to 
   actually write the data out.  Don't ctrl-c in the console.

   I promise that the other application (the one you actually use to
   use the keyboard) is more polished.

   Here are the only mappings I typically use that aren't intuitive :
   Date --> home
   Phone --> End
   Todo --> PageUp
   Memo --> PageDown
   Done --> Ins
   Extra space --> Esc
*/

#include "stdafx.h"
#include "conio.h"
#include "stdio.h"
#include "stdlib.h"


HANDLE hComm;
unsigned char buffer[1024];
int bytesread;
char c;

static char g_szClassName[] = "MyWindowClass";
HINSTANCE g_hInst;

FILE* output;

/* A thread that reads keys from the Palm keyboard and writes
   them out to the output file. */
DWORD WINAPI ThreadProc(LPVOID input) {
	//_cprintf("Print this shite...\n\n");

	hComm = CreateFile("COM1",GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, 0);
	if (hComm == INVALID_HANDLE_VALUE) {
		_cprintf("Handle this, bytch...");
		_getch();
		exit(1);
	}

	DCB dcb = {0};
	
	dcb.DCBlength = sizeof(dcb);
	dcb.BaudRate = 9600;
	dcb.fParity = TRUE;
	dcb.fOutxCtsFlow = FALSE;
	dcb.fOutxDsrFlow = FALSE;
	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fDsrSensitivity = FALSE;
	dcb.fTXContinueOnXoff = TRUE;
	dcb.fOutX = FALSE;
	dcb.fInX = FALSE;
	dcb.fErrorChar = FALSE;
	dcb.fNull = FALSE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	dcb.fAbortOnError = FALSE;
	dcb.wReserved = 0;
	dcb.XonLim = 0;
	dcb.XoffLim = 0;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.XonChar = 0xa;
	dcb.XoffChar = 0xb;
	dcb.ErrorChar = 0;
	dcb.EofChar = EOF;
	dcb.EvtChar = '\0';
	dcb.ByteSize = 8;

	if(SetCommState(hComm,&dcb) == 0) {
		_cprintf("Motherfuck! %ld\n",GetLastError());
	}

	COMMTIMEOUTS cto = {0};

	cto.ReadIntervalTimeout = MAXDWORD;
	cto.ReadTotalTimeoutMultiplier = 0; //MAXDWORD;
	cto.ReadTotalTimeoutConstant = 0; // 1000;
	cto.WriteTotalTimeoutConstant = 0;
	cto.WriteTotalTimeoutMultiplier = 0;

	if (!SetCommTimeouts(hComm, &cto)) {
		_cprintf("God damnit! %ld\n",GetLastError());
	}

	SetupComm(hComm, 1024, 1024);


	while(1) {
	
		if (!(ReadFile(hComm,buffer,1024,(unsigned long *)(&bytesread),0))) {
			_cprintf("I can't read shit...\n\n");
		}

		/* Right now I'm only interested in the first character... */
		if (bytesread > 0) {
			unsigned char c = buffer[0];
			_cprintf("%02x received, %02x ",c,c&(~(1<<7)));
			if ((c&(1<<7)) != 0) {
				// Highest bit is not recorded, high means release
				fprintf(output,"%02x ",c&(~(1<<7)));
				_cprintf("written\n");
			}
		}
	} // infinite loop reading keys from the Palm keyboard

   return 0;

}

LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
   char buf[50];
   int up = 0;
   switch(Message)
   {
      case WM_CLOSE:
         DestroyWindow(hwnd);
      break;
      case WM_DESTROY:
		 fclose(output);
         PostQuitMessage(0);
	  break;

	  /*

      // I was initially recording keyup events separately, but then
	  // I realized that they use the same scan code with a single bit
	  // that's set for up/down
	  case WM_KEYUP :
		  GetKeyNameText(lParam,buf,50);
		  _cprintf("Key %s, vkey %d, scan %d, name %s\n",(up==1)?"up":"down",
			  wParam,(lParam >> 16)&(0xff),buf);
		  if (output != NULL) {
			fprintf(output,"%d\t%d\t%s\n",wParam,(lParam >> 16)&(0xff),buf);
		  }
      */

	  /* When the user presses a key, write the appropriate information
	     out to file. */
	  case WM_KEYDOWN :
		  GetKeyNameText(lParam,buf,50);
		  _cprintf("vkey %d, scan %d, name %s\n",
			  wParam,(lParam >> 16)&(0xff),buf);
		  if (output != NULL) {
			fprintf(output,"\t%d\t%d\t%s\n",wParam,(lParam >> 16)&(0xff),buf);
		  }
		  // Want defwindowproc also
          // break;

      default:
         return DefWindowProc(hwnd, Message, wParam, lParam);
   }
   return 0;
}


int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
   WNDCLASSEX WndClass;
   HWND hwnd;

   // Open the palmkey.ini file
   output = fopen("palmkey.ini","a");
   
   g_hInst = hInstance;

   AllocConsole();
	   
   if(output == NULL) _cprintf("Could not open output file.\n");

   // Write the palmkey.ini header out
   else _cprintf("%d bytes written to file\n",
     fprintf(output,"Palm\tvkey\tscan\tname\n"));
	
   WndClass.cbSize        = sizeof(WNDCLASSEX);
   WndClass.style         = NULL;
   WndClass.lpfnWndProc   = WndProc;
   WndClass.cbClsExtra    = 0;
   WndClass.cbWndExtra    = 0;
   WndClass.hInstance     = g_hInst;
   WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
   WndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   WndClass.lpszMenuName  = NULL;
   WndClass.lpszClassName = g_szClassName;
   WndClass.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

   if(!RegisterClassEx(&WndClass))
   {
      MessageBox(0, "Window Registration Failed!", "Error!",
         MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
      return 0;
   }

   hwnd = CreateWindowEx(
      WS_EX_CLIENTEDGE,
      g_szClassName,
      "Close this window to write the results out to file",
      WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, CW_USEDEFAULT, 450, 240,
      NULL, NULL, g_hInst, NULL);

   if(hwnd == NULL)
   {
      MessageBox(0, "Window Creation Failed!", "Error!",
         MB_ICONEXCLAMATION | MB_OK | MB_SYSTEMMODAL);
      return 0;
   }

   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

   DWORD thread;

   // Create a thread to monitor the palm keyboard
   CreateThread(0,0,ThreadProc,0,0,&thread);
	_cprintf("Created thread %u\n\n",thread);
	//_cprintf("Dan likes console output...\n\n");


	MSG Msg;
	while(GetMessage(&Msg, NULL, 0, 0))
   {
      TranslateMessage(&Msg);
      DispatchMessage(&Msg);
   }

	return 0;
}



