/*****
 * 
 * multi_speech.h
 *
 * Dan Morris
 * dmorris@cs.stanford.edu
 * http://techhouse.brown.edu/dmorris
 *
 * You can do anything you want with this file as long as this 
 * header stays on top and I get credit where it's appropriate.
 *
 *****/

/*****
 *
 * This file defines the CMultiSpeaker class, used to connect to the
 * MS speech SDK and generate speech on specific interfaces.
 *
 *****/
#ifndef _MULTI_SPEECH_H_
#define _MULTI_SPEECH_H_

#ifdef INCLUDE_MULTI_SPEECH

#include <sapi.h>

class CMultiSpeaker {

private:

  int initialized;

  // Number of available sound interfaces
  unsigned long num_devices;

  // Array of voice objects
  ISpVoice** pVoices;
  
  int initialize();
  int uninitialize();
  
public:

  // Initializes COM and the speech SDK
  CMultiSpeaker();
  ~CMultiSpeaker();

  // Takes a wide-character string and speaks the
  // corresponding text...
  //
  // Returns -1 for an error, 0 if all goes well
  int speak_w(int device_mask, const unsigned short* text_w, int purge=0);

  // Takes a standard C string and speaks the 
  // corresponding text...
  //
  // Returns -1 for an error, 0 if all goes well
  int speak(int device_mask, const char* text, int purge=0);

  // Returns the number of identified output devices that can
  // be used for speech output
  int get_num_devices() {
    return num_devices;
  }
};

#endif

#endif
