/*****
 * 
 * multi_snd_jni.cpp
 *
 * Dan Morris
 * dmorris@cs.stanford.edu
 * http://techhouse.brown.edu/dmorris
 *
 * You can do anything you want with this file as long as this 
 * header stays on top and I get credit where it's appropriate.
 *
 *****/

/*****
 *
 * This file defines the DLL entry point for the multi_snd_jni
 * library, and the two java-accessible functions :
 * 
 * get_num_devices()
 * play_sound_multi()
 * speak_text_multi()
 *
 * See MultiSoundPlayer.java for java usage instructions.
 *
 *****/
#include "stdafx.h"
#include "multi_snd_jni.h"

#include <mmsystem.h>
#include <conio.h>

// The java-exported function definitions
#include "MultiSoundPlayer.h"

// The actual code
#include "multi_snd/multi_snd_core.h"
#include "multi_snd/multi_speech.h"
#include "multiple_mp3_test/multidev_mp3.h"

CMultiSpeaker* g_multi_speaker = 0;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 ) {
  switch (ul_reason_for_call) {

  case DLL_PROCESS_ATTACH:
    g_multi_speaker = new CMultiSpeaker();
    break;

  case DLL_THREAD_ATTACH:
    break;

  case DLL_THREAD_DETACH:
    break;

  case DLL_PROCESS_DETACH:
  
    if (g_multi_speaker) delete g_multi_speaker;

    // Can't clean up dshow on a dllmain call...
    //cleanup_dshow();

    break;
  }

  return TRUE;

}


// Returns the number of wave devices available on the system
JNIEXPORT jint JNICALL Java_MultiSoundPlayer_get_1num_1devices
(JNIEnv *, jobject) {

  // This is useful for printing specific device names... 

  WAVEOUTCAPS caps;

  _cprintf("\n");

  unsigned int num_devices = waveOutGetNumDevs();;

  for(unsigned int i  = 0; i < num_devices; i++) {

    waveOutGetDevCaps(i,&caps,sizeof(WAVEOUTCAPS));

    _cprintf("WAV device %02d: %s\n",i,caps.szPname);

  }
    
  return (int)num_devices;

}


// Plays the specified sound on the devices specified in the bitmask
// device_mask.  Returns 0 if all is well, -1 if there's an error.
//
// See the multi_sound_core.cpp file or the MultiSoundPlayer.java
// file for usage details.
JNIEXPORT jint JNICALL Java_MultiSoundPlayer_play_1sound_1multi
  (JNIEnv *env, jobject, jstring filename, jint device_mask) {

  const char *str_filename = env->GetStringUTFChars(filename, 0);

  int result = play_wave_sound(str_filename,device_mask);

  env->ReleaseStringUTFChars(filename, str_filename);

  return result;
}


// Speak the specified text on the devices specified in the bitmask
// device_mask.  Returns 0 if all is well, -1 if there's an error.
//
// See the multi_speech.cpp file or the MultiSoundPlayer.java
// file for usage details.
JNIEXPORT jint JNICALL Java_MultiSoundPlayer_speak_1text_1multi
(JNIEnv *env, jobject, jstring text, jint device_mask, jint purge) {

  const char *str_text = env->GetStringUTFChars(text, 0);

  int result = g_multi_speaker->speak(device_mask,str_text,purge);

  env->ReleaseStringUTFChars(text, str_text);

  return result;
}


JNIEXPORT jint JNICALL Java_MultiSoundPlayer_build_1graph_1for_1file
(JNIEnv *env, jobject, jstring filename, jint device_mask) {

  if (dshow_initialized() == 0) init_dshow();

  // Check for recent events whenever the client calls into the library
  handle_all_graph_events();

  const char *str_filename = env->GetStringUTFChars(filename, 0);

  int result = build_graph_for_file(str_filename,device_mask);

  env->ReleaseStringUTFChars(filename, str_filename);

  return result;
}


JNIEXPORT jint JNICALL Java_MultiSoundPlayer_media_1control
(JNIEnv *, jobject, jint graph_handle, jint operation, jdouble parameter) {

  if (dshow_initialized() == 0) init_dshow();

  // Check for recent events whenever the client calls into the library
  handle_all_graph_events();

  int result = media_control(graph_handle,operation,parameter);

  return result;
}

JNIEXPORT jdouble JNICALL Java_MultiSoundPlayer_get_1duration
(JNIEnv *, jobject, jint graph_handle) {

  return get_duration(graph_handle);
}

JNIEXPORT jdouble JNICALL Java_MultiSoundPlayer_get_1current_1position
(JNIEnv *, jobject, jint graph_handle) {

  return get_current_position(graph_handle);

}