%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [cells] = find_nonzero_cells(experiment,MIN_SPIKES)
%
% returns a list of cells in the experiment file that have at least MIN_SPIKES
% over the course of the experiment
%
% experiment: an experiment struct in the form returned by plx_to_matlab
%
% MIN_SPIKES : the minumum number of spikes to require; defaults to 800
%
% Returns a matrix of size (num_cells,2), with channel in the first column and
% unit in the second column.  Everything is _zero_-indexed in this list.
%
% Dan Morris, Stanford University, 2003
% http://techhouse.brown.edu/~dmorris
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [cells] = find_nonzero_cells(experiment,MIN_SPIKES)

s = experiment.spike_counts;

if (nargin < 2)
    MIN_SPIKES = 800;
end

[i,j] = find(s > MIN_SPIKES);
cells = [i j];

% Return the 0-indexed numbering of the channels and units
cells = cells - 1;