%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [x,y,x1,y1] = forward_kin(x_base,y_base,theta1,theta2,a1,a2);
%
% Performs a forward kinematic transformation for a two-link arm.
%
% x_base,y_base : the position of the 'shoulder'
% theta1,theta2 : the angles of the 'shoulder' and 'elbow' (radians)
% a1,a2         : the length of the 'upper arm' and 'forearm' segments
% 
% Dan Morris, Stanford University, 2003
% http://techhouse.brown.edu/~dmorris
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [x,y,x1,y1] = forward_kin(x_base,y_base,theta1,theta2,a1,a2);

x1 = a1*cos(theta1);
y1 = a1*sin(theta1);

x = a2*cos(theta1+theta2) + x1 + x_base;
y = a2*sin(theta1+theta2) + y1 + y_base;

x1 = x1 + x_base;
y1 = y1 + y_base;
