%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function [theta1, theta2] = inv_kin(x_base,y_base,x_goal,y_goal,a1,a2,elbow_up);
%
% Performs simple two-link inverse kinematics.
%
% x_base,y_base : the position of the 'shoulder'
% x_goal,y_goal : the position of the 'hand'
% a1,a2         : the length of the 'upper arm' and 'forearm' segments
% elbow_up      : 1 or 0, indicating the elbow-up or elbow-down
%                 configuration
%
% Dan Morris, Stanford University, 2003
% http://techhouse.brown.edu/~dmorris
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [theta1, theta2] = inv_kin(x_base,y_base,x_goal,y_goal,a1,a2,elbow_up);

x = x_goal - x_base;
y = y_goal - y_base;

% Note that all of these results are actually vectors of angles
theta2 = real(2*atan(sqrt( ((a1+a2)^2 - (x.^2+y.^2))./((x.^2+y.^2)-(a1-a2)^2))));

if (elbow_up == 1)
    theta2 = theta2 * -1;
end

phi = atan2(y,x);
psi = atan2(a2*sin(theta2),a1+a2*cos(theta2));
theta1 = phi - psi;
