%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [x_predictions,y_predictions,window_times] = 
%  make_predictions(experiment,filter,start_time,end_time)
%
% Generate a vector of neural predictions for the specified interval, using the 
% provided linear filter (see make_filter.m).
%
% The returned vectors are column vectors containing the x and y predictions and the
% times corresponding to the end of each prediction bin.
%
% experiment : an experiment structure in the form returned by plx_to_matlab.m
%
% filter : a filter structure in the form returned by make_filter.m
%
% start_time, end_time : the start and end times to decode, in seconds
%
% Dan Morris, Stanford University, 2003
% http://techhouse.brown.edu/~dmorris
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [x_predictions,y_predictions,window_times] = make_predictions(experiment,filter,start_time,end_time)

cell_list = filter.cell_list + 1;
bin_size = filter.bin_size;
filter_length = filter.filter_length;
num_bins = floor( (end_time - start_time) / bin_size);
num_cells = size(cell_list,1);

% I format the given data into a response matrix in the form specified by Warland et al, since
% this is the format the filter likes to operate on.
[unformatted_response,R] = make_response_matrix(num_cells,num_bins,experiment,cell_list,bin_size,start_time,filter_length);

x_predictions = R * filter.x_filter;
y_predictions = R * filter.y_filter;

window_times = [start_time+bin_size*filter_length:bin_size:end_time]';
