%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function prediction_error(bin_times,predict_x,predict_y,real_xpos,real_ypos)
%
% Computes mean-squared-error for predicted trajectories.  The format of the parameters
% is a little bizarre, but the point is to be compatible with the other scripts
% I'm using.  In particular, there's no good reason that the predicted and real
% positions are in totally different formats, other than the fact that they come
% from different places.
%
% bin_times : this is a vector of time (seconds) that defines the start of each
% bin that should be animated
%
% predict_x,predict_y : vectors of x/y positions, one entry per bin
%
% real_xpos, real_ypos : each of these is a two-column vector.  The first 
% column is time, the second column is the corresponding coordinate.  They
% need not be sync'ed with the bins at all, but obviously they should contain
% the same region in time covered by bin_times.
%
% Dan Morris, Stanford University, 2003
% http://techhouse.brown.edu/~dmorris
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [mse, real_x_binned, real_y_binned] = prediction_error(bin_times,predict_x,predict_y,real_xpos,real_ypos)

if (nargin < 5)
  fprintf(1,'\nUsage: prediction_error(bin_times,predx,predy,realx,realy)\n\n');
  return;
end

real_x_binned = zeros(length(bin_times),1);
real_y_binned = real_x_binned;

start_time = bin_times(1);
cur_bin = 1;
cur_x_index = 1;
cur_y_index = 1;

% find the indices in the 'real' x and y arrays corresponding to the first
% time point
while(cur_x_index <= size(real_xpos,1) & real_xpos(cur_x_index,1) < start_time)
  cur_x_index = cur_x_index + 1;
end

while(cur_y_index <= size(real_ypos,1) & real_ypos(cur_y_index,1) < start_time)
  cur_y_index = cur_y_index + 1;
end

while(cur_bin < length(bin_times))
    
  cur_plex_time = bin_times(cur_bin);

  % advance to the current bin in the real x and y arrays
  while(cur_x_index < size(real_xpos,1) & real_xpos(cur_x_index,1) < cur_plex_time)
    cur_x_index = cur_x_index + 1;
  end

  while(cur_y_index < size(real_ypos,1) & real_ypos(cur_y_index,1) < cur_plex_time)
    cur_y_index = cur_y_index + 1;
  end

  cur_real_x = real_xpos(cur_x_index,2);
  cur_real_y = real_ypos(cur_y_index,2);

  real_x_binned(cur_bin) = cur_real_x;
  real_y_binned(cur_bin) = cur_real_y;

  cur_bin = cur_bin + 1;
end

x_err = real_x_binned - predict_x;
y_err = real_y_binned - predict_y;

mean_x_err = mean(x_err .* x_err);
mean_y_err = mean(y_err .* y_err);

mse = [mean_x_err mean_y_err];
